//-----------------------------------------------------------------------
// OpenGL Pencere minumum izim iin gerekli bir kalp
// Oyunyapimi.org iin hazirlanmistir.
//-----------------------------------------------------------------------
// Proje Adi  : GLWOY
// Hazirliyan : Vedat Meydaneri
// Ama       : OpenGL Pencere modunda alan minumum bir kalp
// Tarih      : 11/04/2005
//-----------------------------------------------------------------------
// Hazirlama amam ise oyunyapimi.org 'a Opengl rnek hazirlamak isteyen 
// arkadaslarin pencere gereksinimi ile uramadan direkt rnei 
// hazirlamaya younlamalarini salamak bylece bunun iin zaman
// kaybetmemelerini salamak.
//-----------------------------------------------------------------------
//Uyari Linkler kismina : OpenGL32.lib glu32.lib gluaux.lib winmm.lib 
//Eer derleyiciniz Vc++ degilse eklenmesi arttir.
//-----------------------------------------------------------------------
// Basliklar.h
//-----------------------------------------------------------------------

#define WIN32_LEAN_AND_MEAN		
// Windows Balmz
#include <windows.h>
// C alma balklari
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <tchar.h>

//OpenGL balklar
#include <gl/gl.h>		
#include <gl/glu.h>	
#include <gl/glaux.h>	

//diger basliklar
#include <stdio.h>
#include <math.h>
#include <mmsystem.h>


//pencere bilgisi
//isterseniz baska degerlerde girebilirsiniz
#define GLWOY_PENCERE (WS_OVERLAPPED | WS_CAPTION |WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX)

#define ACIK 1
#define KAPALI 0

//disardan WndProc u cagiralim
extern LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

//Ktphaneler
// Vc++ iin zel bir durumdur.Eer derleynz farkli ise
// Linkler kismina ekleyiniz.
#pragma comment(lib, "OpenGL32.lib")	
#pragma comment(lib, "Glu32.lib")	
#pragma comment(lib, "Glaux.lib")	
#pragma comment(lib, "winmm.lib")

//FPS icin
struct FPS
{
	float oncekiZaman;	
	float kareZamani;	
    float suankiZaman;
	float kare;
	float dt;
	float fps;
};

//Pencere sinifimiz
class CPencere
{
public:
	CPencere(void);
	~CPencere(void);

	//Pencere giris ayarlari olusturulmasi icin
   BOOL PencereOlustur(HINSTANCE hInstance,int ekranx,int ekrany,char *tanim,char *penceresinifi, int nCmdShow);
	//Pencere icin olusturduklarimizin kaldirilmasi icin
   void Pencere_kapat(void);
	//Doku yuklemek icin (*.BMP)
   GLuint Dokuyukle(char *dosyaadi);

   //sahnemizi yeniden boyutlandirmak icin
  GLvoid SahneyiTekrarCiz(GLsizei en, GLsizei boy);
	//Uyari mesaji
   void uyari(char *hataadi);
   //FPS hesaplamak icin
   void FPShesapla();

   //Ekranda 2b cizim yapmak icin
   void Ekrana2BCizimyap(int acikkapali);

   //Basta OpenGL penceremizde neden izilmis nesneleri temizliyelim
  void Temizle();
  //Son olarak ekrandaki nesneleri cizelim ve sonraki kareye geelim
  void KareyiCizveCevir();

public:
	// Cevresel tanimlamalar:
    HINSTANCE hInst;		
    HWND hWnd;
    HDC hdc;   //windows icin
    HGLRC hRC; //opengl icin
    int px,py;

	//fps iin
    FPS fps;

	char szPencereSinifi[150];
	char szTanim[150];

	//giris ayarlari
	BOOL PikselAyari(int zbuffer,int renk);
	BOOL OpenGLGiris(int px,int py);
	BOOL OpenGLOlustur(int px,int py);


 };
