#if !defined(HIGHRESTIMER_H_INCLUDED_)
#define HIGHRESTIMER_H_INCLUDED_

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

class HighResTimer {

public:
   
   HighResTimer() {
            
      if (m_llFrequency == 0) {
         LARGE_INTEGER  liFrequency;

         QueryPerformanceFrequency(&liFrequency);
         m_llFrequency = liFrequency.QuadPart;
      }
      
   }

   virtual ~HighResTimer() {}

   // start timer
   void start() {
      QueryPerformanceCounter(&m_llCounter);
   }

   // return elapsed seconds since the last start() operation called..
   double elapsed() {
      LARGE_INTEGER  liNow;
      QueryPerformanceCounter(&liNow);
      
      return (double)(liNow.QuadPart - m_llCounter.QuadPart)/m_llFrequency;
      //TRACE(_T("%s : Elapsed time = %.3lf seconds\n"), m_strName, duration);
   }

   

protected:

   LARGE_INTEGER  m_llCounter;

   static LONGLONG   m_llFrequency;

};


#endif


