/****************************************************
 *
 * glBlendTester v0.2
 *
 * code: Mehmet Deniz Aydinoglu
 *
 * This is just a tool to learn and experiment with
 * OpenGL blending modes. GLUT used for windowing, 
 * GLUI for UI management and Nate Miller's tga loading
 * routines for handling tga texture loading.
 *
 * for comments, compiling tips and bug reports:
 * deniz@oyunyapimi.org
 *
 * Licence is GPL (see license.txt)
 *
 ****************************************************
*/

// Uncomment this to use lib3d for Texture handling.
// Using lib3d texture handling has advantages such as
// texture shader support (ie: texture animation) and
// support for many popular image formats (ie: bmp,jpeg,png...)
// For instructions on how to obtain lib3d just mail me deniz@oyunyapimi.org

//#define USE_LIB3D

#include <windows.h>
#define WIN32_LEAN_AND_MEAN
#include <commdlg.h>
#include <shellapi.h>
#include <shlobj.h>

#include <stdio.h>
#include <stdlib.h>

#ifdef USE_LIB3D
   #include <lib3d/lib3d.h>
   #include <lib3d/util2d/Texture.h>
   #pragma comment(lib,"sdl.lib")
   #pragma comment(lib,"sdlmain.lib")
   #pragma comment(lib,"lib3d.lib")
#else
   extern "C" {
      #include "tga.h"
   }
#endif

#include "glui.h"
#include "windialog.h"
#include "HighResTimer.h"

enum eWidgetId { WIDGET_BACK_TEXTURE=0, WIDGET_FRONT_TEXTURE, WIDGET_LOAD_BACK, WIDGET_LOAD_FRONT,
                 WIDGET_SET_TEXPATH, WIDGET_TEXTURE_PATH, WIDGET_RELOAD };

GLUI *glui;

/** These are the live variables passed into GLUI ***/
static int   main_window;
static float color[] = {0.0f,0.0f,0.0f};
static int   rotateFront = 0;
static int   rotateBack  = 0;
static int   renderBackTexture = 1;
static int   renderFrontTexture = 1;
static int   renderBackground = 1;
static int   src_blend_mode_back = 1;
static int   dst_blend_mode_back = 1;
static int   src_blend_mode_front = 4;
static int   dst_blend_mode_front = 5;
float view_rotate[16] = { 1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1 };
float obj_pos[] = { 0.0, 0.0, 0.0 };
static char  back_texture[512];
static char  front_texture[512];
static char  texture_path[512]; 
static char  *src_blend_modes[] =       { "GL_ZERO","GL_ONE","GL_DST_COLOR","GL_ONE_MINUS_DST_COLOR",
                                          "GL_SRC_ALPHA", "GL_ONE_MINUS_SRC_ALPHA", "GL_DST_ALPHA",
                                          "GL_ONE_MINUS_DST_ALPHA", "GL_SRC_ALPHA_SATURATE" };
static int   src_blend_modes_consts[] = { GL_ZERO,GL_ONE,GL_DST_COLOR,GL_ONE_MINUS_DST_COLOR,
                                          GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA,
                                          GL_ONE_MINUS_DST_ALPHA, GL_SRC_ALPHA_SATURATE };

static char  *dst_blend_modes[] =       { "GL_ZERO", "GL_ONE", "GL_SRC_COLOR", "GL_ONE_MINUS_SRC_COLOR",
                                          "GL_SRC_ALPHA", "GL_ONE_MINUS_SRC_ALPHA", "GL_DST_ALPHA",
                                          "GL_ONE_MINUS_DST_ALPHA"};
static int   dst_blend_modes_consts[] = { GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR,
                                          GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA,
                                          GL_ONE_MINUS_DST_ALPHA};

#ifdef USE_LIB3D
Texture *frontTexture=0, *backTexture=0;
#else
unsigned int frontTexture_id=-1,backTexture_id=-1;
#endif

HighResTimer timer;

bool openFileDialog(char *filename);
bool openDirectoryDialog(char *dirname);
void setupGLUIWidgets();

// glut idle function
void idleCB( void ) {

   if ( glutGetWindow() != main_window ) 
     glutSetWindow(main_window);  

   glutPostRedisplay();
}

// glut reshape function
void reshapeCB( int x, int y ) {
  
   float xy_aspect;

   xy_aspect = (float)x / (float)y;
   glViewport(0,0,x,y);

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(50.0f,xy_aspect,0.1f,1000.0f);

   glMatrixMode(GL_MODELVIEW);
   glutPostRedisplay();
}

// glut render function
void displayCB( void ) {
 
   static float rotangle_front=0;
   static float rotangle_back=0;
   double dElapsed = timer.elapsed();
   timer.start();
   
   glClearColor(color[0],color[1],color[2],1.0f);
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   
   glLoadIdentity();
   glTranslatef(0,7,-50.0);
   
   // render simple background scene if enabled
   if (renderBackground) {
      glEnable(GL_LIGHTING);
      glDisable(GL_TEXTURE_2D);
      glPushMatrix();
      glTranslatef(0,20,-100);
      glColor3f(0.9f,0.1f,0.2f);
      glutSolidSphere(10,20,20);
      glTranslatef(30,10,0);
      glColor3f(0.1f,0.9f,0.2f);
      glutSolidSphere(20,20,20);
      glPopMatrix();
      glDisable(GL_LIGHTING);
      glEnable(GL_TEXTURE_2D);
   }
   
   // transform view to match transformation and rotation widgets
   glTranslatef(obj_pos[0],obj_pos[1],-obj_pos[2]); 
   glMultMatrixf(view_rotate);

   // rotate back and front textures if enabled
   if (rotateFront)
      rotangle_front += 100.0f * dElapsed;
   if (rotateBack)
      rotangle_back += 100.0f  * dElapsed;

   // set back texture blending parameters
   glEnable(GL_BLEND);
   glBlendFunc(src_blend_modes_consts[src_blend_mode_back],dst_blend_modes_consts[dst_blend_mode_back]);
   glColor3fv(color);
   
   // render back texture if enabled
   if (renderBackTexture) {
      glPushMatrix();      
      glRotatef(rotangle_back,0,0,1);
      glScalef(20,20,1);
      glColor3f(1,1,1);

#ifdef USE_LIB3D      
      backTexture->begin();
#else
      glBindTexture(GL_TEXTURE_2D,backTexture_id);
#endif
      
      glBegin(GL_QUADS);
      glTexCoord2f(0,1); glVertex3f(-0.5f, 0.5f, 0.0f);
      glTexCoord2f(0,0); glVertex3f(-0.5f,-0.5f, 0.0f);
      glTexCoord2f(1,0); glVertex3f( 0.5f,-0.5f, 0.0f);
      glTexCoord2f(1,1); glVertex3f( 0.5f, 0.5f, 0.0f);
      glEnd();

#ifdef USE_LIB3D
      backTexture->end();
#endif

      glPopMatrix();
   }

   // set front texture blending parameters
   glBlendFunc(src_blend_modes_consts[src_blend_mode_front],dst_blend_modes_consts[dst_blend_mode_front]);
   
   // render front texture if enabled
   if (renderFrontTexture) {
      glPushMatrix();
      glRotatef(rotangle_front,0,0,1);      
      glTranslatef(0,0,0.1f);      
      glScalef(20,20,1);
      glColor3f(1,1,1);

#ifdef USE_LIB3D
      frontTexture->begin();
#else
      glBindTexture(GL_TEXTURE_2D,frontTexture_id);
#endif

      glBegin(GL_QUADS);
      glTexCoord2f(0,1); glVertex3f(-0.5f, 0.5f, 0.0f);
      glTexCoord2f(0,0); glVertex3f(-0.5f,-0.5f, 0.0f);
      glTexCoord2f(1,0); glVertex3f( 0.5f,-0.5f, 0.0f);
      glTexCoord2f(1,1); glVertex3f( 0.5f, 0.5f, 0.0f);
      glEnd();

#ifdef USE_LIB3D
      frontTexture->end();
#endif
      
      
      glPopMatrix();
   }

   glDisable(GL_BLEND);
   
   glutSwapBuffers(); 
}

// GLUI widget callback functions
void widgetCB(int wid) {

   static char filename[256];
   
   switch(wid) {
      case WIDGET_LOAD_BACK:

         if (openFileDialog(filename)) {
            
            SetCurrentDirectory(texture_path);
            
            strcpy(back_texture,filename);
            fprintf(stdout,"debug: loading back texture: %s\n",back_texture);
            
#ifdef USE_LIB3D
            if (backTexture) {
               delete backTexture;
            }         
            backTexture = new Texture(back_texture);
            backTexture->build();
#else
            glGenTextures(1,&backTexture_id);
            if (loadTGA(back_texture,backTexture_id) != 1) {
               MessageBox(0,"HATA: dosya yuklenemedi!","HATA",0);
            }
#endif

         }
         break;

      case WIDGET_LOAD_FRONT:

         if (openFileDialog(filename)) {
            
            SetCurrentDirectory(texture_path);
            
            strcpy(front_texture,filename);
            fprintf(stdout,"debug: loading front texture: %s\n",front_texture);
            
#ifdef USE_LIB3D
            if (frontTexture) {
               delete frontTexture;
            }         
            frontTexture = new Texture(front_texture);
            frontTexture->build();
#else
            glGenTextures(1,&frontTexture_id);
            if (loadTGA(front_texture,frontTexture_id) != 1) {
               MessageBox(0,"HATA: dosya yuklenemedi!","HATA",0);
            }
#endif

         }
         break;

      case WIDGET_SET_TEXPATH:

         if (openDirectoryDialog(filename)) {
            
            strcpy(texture_path,filename);
            SetCurrentDirectory(texture_path);

            fprintf(stdout,"debug: texture path set: %s\n",texture_path);
            
         }
         break;

      case WIDGET_RELOAD:

         SetCurrentDirectory(texture_path);

#ifdef USE_LIB3D
         if (backTexture) {
            delete backTexture;
         }         
         backTexture = new Texture(back_texture);
         backTexture->build();
         if (frontTexture) {
            delete frontTexture;
         }         
         frontTexture = new Texture(front_texture);
         frontTexture->build();
#else
         glGenTextures(1,&backTexture_id);
         glGenTextures(1,&frontTexture_id);
         if (loadTGA(back_texture,backTexture_id) != 1) {
            MessageBox(0,"HATA: dosya yuklenemedi!","HATA",0);
         }
         if (loadTGA(front_texture,frontTexture_id) != 1) {
            MessageBox(0,"HATA: dosya yuklenemedi!","HATA",0);
         }
#endif

   
   };

   GLUI_Master.sync_live_all();

}


// This function creates GLUI widgets
void setupGLUIWidgets() {

   glui = GLUI_Master.create_glui_subwindow (main_window,GLUI_SUBWINDOW_BOTTOM);
   glui->set_main_gfx_window(main_window);

   GLUI_Master.set_glutIdleFunc(idleCB); 

   // create widgets..
   
   // color spinners..   
   GLUI_Panel   *panel1 = glui->add_panel("Background Color");
   GLUI_Spinner *red_spinner   = glui->add_spinner_to_panel(panel1,"red:",GLUI_SPINNER_FLOAT,&(color[0]));
   GLUI_Spinner *green_spinner = glui->add_spinner_to_panel(panel1,"grn:",GLUI_SPINNER_FLOAT,&(color[1]));
   GLUI_Spinner *blue_spinner  = glui->add_spinner_to_panel(panel1,"blu:",GLUI_SPINNER_FLOAT,&(color[2]));
   red_spinner->set_float_limits(0.0f,1.0f);
   green_spinner->set_float_limits(0.0f,1.0f);
   blue_spinner->set_float_limits(0.0f,1.0f);

   // back space toggler
   glui->add_checkbox("Render background",&renderBackground);

   glui->add_column(false);
   
   // texture selection
   GLUI_Panel   *panel2 = glui->add_panel("Textures");
   GLUI_Panel   *panel2_1 = glui->add_panel_to_panel(panel2,"",GLUI_PANEL_RAISED);
   GLUI_EditText *back_texture_edit = glui->add_edittext_to_panel(
      panel2_1,"Back Texture:",GLUI_EDITTEXT_TEXT,back_texture,WIDGET_BACK_TEXTURE,widgetCB
   );
   glui->add_column_to_panel(panel2_1,false);
   glui->add_checkbox_to_panel(panel2_1,"",&renderBackTexture);         
   glui->add_column_to_panel(panel2_1,false);
   GLUI_Button *load_tex1_button = glui->add_button_to_panel(panel2_1,"...",WIDGET_LOAD_BACK,widgetCB);
   load_tex1_button->set_w(15);

   GLUI_Panel   *panel2_2 = glui->add_panel_to_panel(panel2,"",GLUI_PANEL_RAISED);
   GLUI_EditText *front_texture_edit = glui->add_edittext_to_panel(
      panel2_2,"Front Texture:",GLUI_EDITTEXT_TEXT,front_texture,WIDGET_FRONT_TEXTURE,widgetCB
   );
   glui->add_column_to_panel(panel2_2,false);
   glui->add_checkbox_to_panel(panel2_2,"",&renderFrontTexture);
   glui->add_column_to_panel(panel2_2,false);
   GLUI_Button *load_tex2_button = glui->add_button_to_panel(panel2_2,"...",WIDGET_LOAD_FRONT,widgetCB);
   load_tex2_button->set_w(15);

   GLUI_Panel   *panel2_3 = glui->add_panel_to_panel(panel2,"",GLUI_PANEL_RAISED);
   GLUI_EditText *texture_path_edit = glui->add_edittext_to_panel(
      panel2_3,"Texture Path:",GLUI_EDITTEXT_TEXT,texture_path,WIDGET_TEXTURE_PATH,widgetCB
   );
   glui->add_column_to_panel(panel2_3,false);
   GLUI_Button *set_texpath_button = glui->add_button_to_panel(panel2_3,"...",WIDGET_SET_TEXPATH,widgetCB);
   set_texpath_button->set_w(15);

   GLUI_Button *reload_button = glui->add_button_to_panel(panel2,"Reload Textures",WIDGET_RELOAD,widgetCB);

   // rotation toggler
   glui->add_checkbox("Rotate front",&rotateFront);
   glui->add_checkbox("Rotate back",&rotateBack);
   
   glui->add_column(false);
   
   // Blend Mode Selection
   GLUI_Rollout *panel3 = glui->add_rollout("Back Texture BlendMode",true);
   GLUI_Listbox *list_src = glui->add_listbox_to_panel(panel3,"Src:",&src_blend_mode_back);
   for (int i=0;i<9;++i)
      list_src->add_item(i,src_blend_modes[i]);
   
   GLUI_Listbox *list_dst = glui->add_listbox_to_panel(panel3,"Dst:",&dst_blend_mode_back);
   for (i=0;i<8;++i)
      list_dst->add_item(i,dst_blend_modes[i]);
   
   GLUI_Rollout *panel4 = glui->add_rollout("Front Texture BlendMode",true);
   GLUI_Listbox *list_src1 = glui->add_listbox_to_panel(panel4,"Src:",&src_blend_mode_front);
   for (i=0;i<9;++i)
      list_src1->add_item(i,src_blend_modes[i]);
   
   GLUI_Listbox *list_dst1 = glui->add_listbox_to_panel(panel4,"Dst:",&dst_blend_mode_front);
   for (i=0;i<8;++i)
      list_dst1->add_item(i,dst_blend_modes[i]);
   
   // rotation and translation
   GLUI_Panel   *panel5 = glui->add_panel("");
   GLUI_Rotation *view_rot = glui->add_rotation_to_panel(panel5,"Rotation",view_rotate);
   //view_rot->set_spin( 1.0 );
   glui->add_column_to_panel(panel5,false);
   GLUI_Translation *trans_xy = glui->add_translation_to_panel(panel5,"Translation",GLUI_TRANSLATION_XY,obj_pos);
   trans_xy->set_speed(0.1f);
   
   GLUI_Master.sync_live_all();   

}

int __stdcall WinMain(HINSTANCE,HINSTANCE,LPSTR,int) {
//int main(int argc, char **argv) {
  
   // initialize glut, create window
   glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
   glutInitWindowPosition(50,50);
   glutInitWindowSize(700,600);
 
   main_window = glutCreateWindow( "glBlendTester v0.2 :: deniz@oyunyapimi.org :: 06/05/2005" );
   glutDisplayFunc(displayCB);
   glutReshapeFunc(reshapeCB);  

   // set default lighting values
   GLfloat light0_ambient[] =  {0.1f, 0.1f, 0.1f, 1.0f};
   GLfloat light0_diffuse[] =  {1.0f, 1.0f, 1.0f, 1.0f};
   GLfloat light0_position[] = {1.0f, 1.0f, 1.0f, 0.0f};

   glEnable(GL_LIGHT0);
   glLightfv(GL_LIGHT0, GL_AMBIENT, light0_ambient);
   glLightfv(GL_LIGHT0, GL_DIFFUSE, light0_diffuse);
   glLightfv(GL_LIGHT0, GL_POSITION, light0_position);
   glDisable(GL_LIGHTING);
   
   // set required OpenGL states
   glEnable(GL_DEPTH_TEST);
   glEnable(GL_COLOR_MATERIAL);
   glEnable(GL_NORMALIZE);
   glEnable(GL_TEXTURE_2D);

   // set default texture names
   GetCurrentDirectory(512,texture_path);
   sprintf(back_texture,"%s\\%s",texture_path,"back.tga");
   sprintf(front_texture,"%s\\%s",texture_path,"front.tga");
      
#ifdef USE_LIB3D
   // initialize lib3d library - used for Textures and Texture shaders
   initLib3d();
   
   // load and initialize default textures
   frontTexture = new Texture(front_texture);
   backTexture  = new Texture(back_texture);
   frontTexture->build();
   backTexture->build();
#else
   glGenTextures(1,&frontTexture_id);
   glGenTextures(1,&backTexture_id);
   if (loadTGA(front_texture,frontTexture_id) != 1) {
      MessageBox(0,"HATA: dosya yuklenemedi!","HATA",0);   
   }
   if (loadTGA(back_texture,backTexture_id) != 1) {
      MessageBox(0,"HATA: dosya yuklenemedi!","HATA",0);   
   }
#endif

   // create GLUI widgets
   setupGLUIWidgets();

   timer.start();
   
   // let the show begin..
   glutMainLoop();
   return 0;
}

