#include "windialog.h"

// this function displays a windows file selection dialog
bool openFileDialog(char *filename) {

   static OPENFILENAME OpenFileName;
   
#ifdef USE_LIB3D   
   TCHAR szFilter[]=__TEXT("Images(*.jpg,*.png,*.tga,*.bmp,*.pcx,*.gif,*.tif,*.lbm)\0\
      *.jpg;*.png;*.tga;*.bmp;*.pcx;*.gif;*.tif;*.lbm\0Lib3D shaders(*.shader)\0*.shader\0\0");
   
   static char *filter[] = {"Image files","*.jpg;*.png;*.tga;*.bmp;*.pcx;*.gif",
                            "Lib3d shader","*.shader",NULL,NULL};

#else

   TCHAR szFilter[]=__TEXT("Uncompressed TGA files (*.tga)\0*.tga\0");
   
   static char *filter[] = {"Uncompressed TGA files","*.tga",NULL,NULL};

#endif
   
   OpenFileName.lStructSize = sizeof (OPENFILENAME);
   OpenFileName.hwndOwner = GetActiveWindow();
   OpenFileName.hInstance = (HINSTANCE)NULL;
   OpenFileName.lpstrFilter = szFilter;
   OpenFileName.lpstrCustomFilter = NULL;
   OpenFileName.nMaxCustFilter = 0L;
   OpenFileName.nFilterIndex = 0L;
   OpenFileName.lpstrFile = filename;
   OpenFileName.nMaxFile = 256;
   OpenFileName.lpstrFileTitle = NULL;
   OpenFileName.nMaxFileTitle = 0;
   OpenFileName.lpstrInitialDir = NULL;
   OpenFileName.lpstrTitle = NULL;
   OpenFileName.nFileOffset = 0;
   OpenFileName.nFileExtension = 0;
   OpenFileName.lpstrDefExt = NULL;
   OpenFileName.lCustData = 0; 

   if (GetOpenFileName (&OpenFileName)) {
      // Open the file.
      HANDLE hFile;
      if ((hFile = CreateFile ((LPCTSTR)OpenFileName.lpstrFile,
                                 GENERIC_READ,
                                 FILE_SHARE_READ,
                                 NULL,
                                 OPEN_EXISTING,
                                 FILE_ATTRIBUTE_NORMAL,
                                 (HANDLE)NULL)) == (HANDLE)(-1))
      {
         return false;
      }
      filename = OpenFileName.lpstrFile;
      return true;
   }
   
   return false;
}

// this function display a windows directory selection dialog
bool openDirectoryDialog(char *dirname) {

   static char path[MAX_PATH];
   
   BROWSEINFO binfo;
   binfo.hwndOwner = GetActiveWindow();
   binfo.pidlRoot = NULL;
   binfo.pszDisplayName = path;
   binfo.lpszTitle = "Select Texture Path";
   binfo.ulFlags = 0;
   binfo.lParam = 0;
   binfo.iImage = 0;
   binfo.lpfn = NULL;

   ITEMIDLIST *item;

   if (item = SHBrowseForFolder(&binfo)) {
      
      SHGetPathFromIDList(item,path);
      strcpy(dirname,path);
   
      return true;
   }
   
   return false;
}
