#include "Player.h"
#include <math.h>

Player :: Player() {

   setScore(0);
   setEnergy(0);
   setSpeed(0.1f);
   setAcc(0.1f);
   setMaxSpeed(100);
   setFriction(0.5f);
   setDirection(0,0,0);
   ball.setPosition(0,0,0);
   ball.setColor(0,0.4,0.9);
   
   size = 5;
   ball.setRadius(size);
}

Entity* Player :: getEntity() const {
   return (Entity*)&ball;
}

float Player :: getSize() {
   return ball.getRadius();
}

void Player :: setSize(float size) {
   ball.setRadius(size);
}

void  Player :: setDirection(float dirx,float diry,float dirz) {
   dir.x = dirx;
   dir.y = diry;
   dir.z = dirz;
}

Vec3d Player :: getDirection() {
   return dir;
}

void  Player :: setPosition(float x,float y,float z) {
   ball.setPosition(x,y,z);
}

Vec3d Player :: getPosition() {
   return ball.getPosition();
}

void  Player :: setEnergy(float e) {
   energy = e;
}

float Player :: getEnergy() {
   return energy;
}

int   Player :: getScore() {
   return score;
}

void  Player :: setScore(int scr) {
   score = scr;
}

void  Player :: setFriction(float f) {
   friction = f;
}

void  Player :: setSpeed(float s) {
   speed = s;
}

float Player :: getSpeed() {
   return speed;
}

void  Player :: setMaxSpeed(float s) {
   maxSpeed = s;
}

float Player :: getMaxSpeed() {
   return maxSpeed;
}

void  Player :: setAcc(float a) {
   acc = a;
}

float Player :: getAcc() {
   return acc;
}

void Player :: setColor(float r,float g,float b) {
   ball.setColor(r,g,b);
}

void Player :: updatePosition(bool n,bool s,bool e,bool w,float dt) {

   // basilan tuslara gore yon vektoru uzerinde gunlemeler yapiliyor..
   if (n) dir.z += -dt * 15;
   if (s) dir.z +=  dt * 15;
   if (w) dir.x += -dt * 15;
   if (e) dir.x +=  dt * 15;

   // herhangi bir tusa basilma var ise hiz kazanma saglaniyor, ayni zamanda
   // en yuksek izin verilen hizin gecilmesi de engelleniyor.
   if (n || s || w || e) {
      speed += acc * dt;
      if (speed > maxSpeed) speed = maxSpeed;
   }
   else {
      
      // tusa basilma yok ise yavas yavas frenleme islemi gerceklestiriliyor..      
      speed -= friction * dt;
      if (speed < 0) speed = 0;
   }

   // yukarida yapilan gunleme islemleri sonucu yon vektoru birim vektor
   // olma durumundan cikmis olabilir. Burada yon vektorunu tekrar birim vektor
   // durumuna getiriyoruz..
   float len = sqrt(dir.x*dir.x+dir.y*dir.y+dir.z*dir.z);
   if (len != 0) {
      dir.x /= len;
      dir.y /= len;
      dir.z /= len;
   }

   // Yon vektoru dogrultusunca, hiz da dikkate alinarak olusturulan delta oteleme
   // vektoru ile top hareket ettiriliyor..
   Vec3d delta;
   delta.x = dir.x * speed * dt * 100;
   delta.y = dir.y * speed * dt * 100;
   delta.z = dir.z * speed * dt * 100;
   ball.move(&delta);

}

void Player :: render() {

   // Once top ciziliyor..
   glPushMatrix();
   ball.render();
   glPopMatrix();

   glLineWidth(2);
   glDisable(GL_LIGHTING);

   // Bu kisimda ise yonumuzu belli eden cizgi topun hemen ustune hareket yonu
   // dogrultusunca ciziliyor..
   Vec3d pos = getPosition();
   Vec3d col = ball.getColor();
   glBegin(GL_LINES);
      glColor3f(col.x,col.y,col.z);
      glVertex3f(pos.x,pos.y+10,pos.z);
      glColor3f(1,1,1);
      glVertex3f(pos.x+dir.x*5,pos.y+10,pos.z+dir.z*5);
   glEnd();

   glEnable(GL_LIGHTING);
   glLineWidth(1);

}