#include <gl/glut.h>
#include <math.h>

void draw_circ(int cx, int cy, float sweep_angle, float angle, float radius) {

  const int n = 500;
  float ang = sweep_angle * 3.14159265/180;
  float ang_inc = angle * 3.14159265/(180*n);
  int k;
  glBegin(GL_POINTS);
  for(k=1; k <= n; k++, ang+=ang_inc) 
    glVertex2f((GLfloat)cx+radius*cos(ang), (GLfloat)cy+radius*sin(ang));
  glEnd();

}

void init(void) {

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(-5.0, 5.0, 5.0, 5.0);
  glViewport(0, 0, 500, 500);
}
void display(void) {

  int m;
  glClearColor(1.0, 1.0, 1.0, 1.0);
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(0.0, 0.0, 0.0);

  for(m=0; m<4; m++) {
    draw_circ(1-m, 0, 0.0, 360.0, m); 
    draw_circ(1, m, 0.0,360.0, m); 
    draw_circ(1, -m, 0.0, 360.0, m); 
  }
  glFlush();
  
}

int main(int argc, char **argv) {
  int win;
  glutInit(&argc, argv);
  glutInitWindowPosition(100, 100);
  glutInitWindowSize(500, 500);
  win = glutCreateWindow("Smith Charts");
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  init();
  glutDisplayFunc(display);
  glutMainLoop();

 return 0;
}
