#include <gl/glut.h>
#include <math.h>


void init(void) {
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(-25.0, 25.0, -25.0, 25.0);
  glViewport(0, 0, 500, 500);
}

void draw_ellipse(float a, float b) {

	float x;
glBegin(GL_POINTS);
for( x=-a; x<=a; x+=0.01) {
	glVertex2f(x, sqrt((b*b)*(1-((x*x)/(a*a)))));
	glVertex2f(x, -sqrt((b*b)*(1-((x*x)/(a*a)))));
}
glEnd();
}

void display(void) {

  float a=20.0, b=15.0;

  glClearColor(1.0, 1.0, 1.0, 1.0);
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(0.0, 0.0, 0.0);

  draw_ellipse(a, b);
glFlush();

glBegin(GL_LINES);
	glVertex2f(-25.0, 0.0);
	glVertex2f(25.0, 0.0);
	glVertex2f(0.0, -25.0);
	glVertex2f(0.0, 25.0);
glEnd();
glFlush();
}

int main(int argc, char **argv) {

  int win;
  glutInit(&argc, argv);
  glutInitWindowPosition(100, 100);
  glutInitWindowSize(500, 500);
  win = glutCreateWindow("Ellipse");
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  init();
  glutDisplayFunc(display);
  glutMainLoop();

  return 0;
}
